//
//  MainProcess.swift
//  Handy Harp Client
//  
//  Created by KIRA Ryouta on 2025/11/17.
//
/*
 MIT License

 Copyright (c) 2025 PROCYON STUDIO CO., LTD.
 Copyright (c) 2025 KIRA Ryouta

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

import SwiftUI
import Combine
import Carbon

func getFrontmostAppBundleId() -> String? {
    if let app = NSWorkspace.shared.frontmostApplication {
        return app.bundleIdentifier
    }
    return nil
}

class ObjCObject : NSObject {

    init(sleepProcess: @escaping () -> Void, wakeProcess: @escaping () -> Void) {
        self.sleepProcess = sleepProcess
        self.wakeProcess = wakeProcess
        super.init()

        let nc = NSWorkspace.shared.notificationCenter
        nc.addObserver(self, selector: #selector(self.handleWillSleepNotification), name: NSWorkspace.willSleepNotification, object: nil)
        nc.addObserver(self, selector: #selector(self.handleDidwakeNotification), name: NSWorkspace.didWakeNotification, object: nil)
    }

    var sleepProcess: () -> Void
    var wakeProcess: () -> Void

    @objc func handleWillSleepNotification() {
        sleepProcess()
    }

    @objc func handleDidwakeNotification() {
        wakeProcess()
    }
}

class MainObject : ObservableObject {
    let client: HHC_NetworkClient
    let objc: ObjCObject
    @Published var connected: Bool = false
    var observation: [NSKeyValueObservation] = []

    init() {
        let client = HHC_NetworkClient()
        self.client = client
        self.objc = .init(sleepProcess: {
            client.running = false
        }, wakeProcess: {
            client.running = true
        })
        let observer = client.observe(\.connected) {[weak self] client, _ in
            if let self = self {
                self.connected = client.connected
            }
        }
        self.observation.append(observer)
        client.receiveCommand = {command in
            if let currentAppBundleId = getFrontmostAppBundleId() {
                print ("AppBundleId: \(currentAppBundleId)")
                if let appType = AppType.forBundleIdentifier(bundleIdentifier: currentAppBundleId) {
                    if let keys = appType.keyCommands(command: command) {
                        sendKeySequence(keys)
                    }
                }
            }
        }
        test()
    }

    deinit {
        for observer in observation {
            observer.invalidate()
        }
    }

    func test() {
        // push shift key for testing
        sendKeyCommand(key: CGKeyCode(kVK_Shift), flags: [])
    }
}

